package com.infoepoch.pms.dispatchassistant.domain.basic.role;


import com.infoepoch.pms.dispatchassistant.domain.basic.menu.Menu;

import java.util.List;

/**
 * @author xuyj
 * @description 角色菜单关联
 * @date 2019-11-14 11:08
 */
public interface IRoleMenuRepository {
    /**
     * 批量插入
     *
     * @param roleId  角色id
     * @param menuIds 菜单集合
     */
    void batchInsert(String roleId, List<String> menuIds, List<String> invoiceList);

    /**
     * 根据角色id删除所有关联数据
     *
     * @param roleId
     */
    void deleteAll(String roleId);

    /**
     * 根据角色id查询关联的菜单
     *
     * @param roleId
     * @return
     */
    List<Menu> select(String roleId);

    /**
     * 查找权限结合
     *
     * @param menuId
     * @param roleId
     * @return
     */
    List<String> selectInvoice(String menuId, List<String> roleId);
}
