package com.infoepoch.pms.dispatchassistant.controller.langchain;


import com.infoepoch.pms.dispatchassistant.common.component.Result;
import com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation.line.ConversationLineCriteria;
import com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation.line.ConversationLineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/conversation-line")
public class ConversationLineController {

    @Autowired
    private ConversationLineService service;

    /**
     * 查询会话行列表
     *
     * @param criteria
     * @return
     */
    @PostMapping("/list")
    public Result list(@RequestBody ConversationLineCriteria criteria) {
        return Result.successData(service.list(criteria));
    }

}
