package com.infoepoch.pms.dispatchassistant.common.utils;

public class CommonTool {

    /**
     * 部门名称裁剪
     *
     * @param departmentName
     * @return
     */
    public static String departmentNameCutOut(String departmentName) {
        return departmentNameCutOut(departmentName, "江苏\\");
    }


    /**
     * 部门名称裁剪
     *
     * @param departmentName
     * @param cutOutStr
     * @return
     */
    public static String departmentNameCutOut(String departmentName, String cutOutStr) {
        return departmentNameCutOut(departmentName, cutOutStr, "");
    }

    /**
     * 部门名称裁剪
     *
     * @param departmentName
     * @param cutOutStr
     * @param defaultStr
     * @return
     */
    public static String departmentNameCutOut(String departmentName, String cutOutStr, String defaultStr) {
        if (StringUtils.isBlank(departmentName))
            return defaultStr;
        if (StringUtils.isBlank(cutOutStr))
            return departmentName;
        if (departmentName.startsWith(cutOutStr)) {
            return departmentName.substring(cutOutStr.length());
        }
        return departmentName.replace(cutOutStr, "");
    }

}
