package com.infoepoch.pms.dispatchassistant.common.component;

/**
 * 分页查询参数
 */
public class PageCriteria {

    public static Integer startIndex(Integer pageIndex,Integer pageSize) {
        return new PageCriteria(pageIndex,pageSize).startIndex();
    }

    /**
     * 页码自增
     */
    public void pageIndexAdd() {
        this.pageIndex += 1;
    }

    public Integer startIndex() {
        if(this.getPageIndex() <= 0) {
            return 1;
        } else {
            return (this.getPageIndex() - 1) * this.getPageSize() + 1;
        }
    }

    public Integer endIndex() {
        if(this.getPageIndex() <= 0) {
            return this.getPageSize();
        } else {
            return this.getPageIndex() * this.getPageSize();
        }
    }

    public PageCriteria() {
    }

    public PageCriteria(Integer pageIndex, Integer pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    private boolean paginationFlag;
    private Integer pageIndex;
    private Integer pageSize;

    public boolean isPaginationFlag() {
        return paginationFlag;
    }

    public void setPaginationFlag(boolean paginationFlag) {
        this.paginationFlag = paginationFlag;
    }

    public Integer getPageIndex() {
        return pageIndex == null ? 0 : pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        if(pageIndex < 0) {
            this.pageIndex = 0;
        } else {
            this.pageIndex = pageIndex;
        }
    }

    public Integer getPageSize() {
        return pageSize == null ? 10 : pageSize;
    }

    public void setPageSize(Integer pageSize) {
        if(pageSize <= 0) {
            this.pageSize = 10;
        } else {
            this.pageSize = pageSize;
        }
    }
}
