package com.infoepoch.pms.dispatchassistant;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author jiangyz
 * @date 2025/4/18 8:58
 */
@SpringBootApplication
@ServletComponentScan
@EnableScheduling
@EnableCaching
@EnableAsync
@ComponentScan("com.infoepoch.pms")
public class DispatchAssistantApplication {
    public static void main(String[] args) {
        System.getProperties().setProperty("oracle.jdbc.J2EE13Compliant", "true");
        SpringApplication.run(DispatchAssistantApplication.class, args);
    }
}