/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset;

import com.oceanbase.jdbc.ServerSidePreparedStatement;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.Cursor;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.IOException;
import java.sql.SQLException;

public class CursorResultSet
extends Cursor {
    private int statementId;
    protected boolean isServerSide = false;
    private int clientStartIndex = 0;
    private int clientEndIndex = 0;
    private int currentIndex = 0;
    private int fetchIndex = 0;
    private int lastRowIndex = 0;

    public CursorResultSet(ColumnDefinition[] columnsInformation, Results results, Protocol protocol, boolean callableResult, boolean eofDeprecated, boolean isPsOutParamter) throws IOException, SQLException {
        super(columnsInformation, results, protocol, callableResult, eofDeprecated, isPsOutParamter);
        this.statementId = results.getStatementId();
        if (protocol.supportFetchWithOffset()) {
            if (this.resultSetScrollType == 1003) {
                this.isServerSide = true;
            } else if (protocol.supportStmtPrepareExecute()) {
                this.isServerSide = true;
            }
            if (this.isServerSide && this.dataSize > 0) {
                this.clientStartIndex = 1;
                this.clientEndIndex = this.dataSize;
                this.setLastRowIndex();
            }
        }
    }

    private void setLastRowIndex() {
        if (this.isLastRowSent && this.lastRowIndex != this.clientEndIndex) {
            this.lastRowIndex = this.clientEndIndex;
        }
    }

    @Override
    protected void cursorFetch() throws SQLException {
        if (this.isLastRowSent) {
            return;
        }
        try {
            ((ServerSidePreparedStatement)this.getStatement()).cursorFetch(this.statementId, this.getFetchSize());
        }
        catch (SQLException e) {
            if ("ORA-01002: fetch out of sequence".equals(e.getMessage())) {
                this.isLastRowSent = true;
            }
            throw e;
        }
        try {
            this.getCursorFetchData(this.fetchSize);
        }
        catch (IOException e) {
            this.handleIoException(e);
        }
    }

    private void cursorFetchForOracle(byte offsetType, int offset) throws SQLException {
        try {
            ((ServerSidePreparedStatement)this.getStatement()).cursorFetchForOracle(this.statementId, this.getFetchSize(), offsetType, offset);
        }
        catch (SQLException e) {
            if ("ORA-01002: fetch out of sequence".equals(e.getMessage())) {
                this.isLastRowSent = true;
                return;
            }
            throw e;
        }
        try {
            this.getCursorFetchData(this.fetchSize);
        }
        catch (IOException e) {
            this.handleIoException(e);
        }
    }

    protected void getCursorFetchData(int tmpFetchSize) throws IOException, SQLException {
        if (this.resultSetScrollType == 1003) {
            this.lastRowPointer = -1;
            if (this.dataSize > 0) {
                this.discardedRows += this.dataSize;
                this.dataSize = 0;
            }
            super.resetState();
        }
        if (this.isServerSide) {
            this.dataSize = 0;
            this.lastRowPointer = -1;
        } else if (this.dataSize == -1) {
            this.dataSize = 0;
        }
        while (tmpFetchSize >= 0 && super.readNextValue()) {
            --tmpFetchSize;
        }
        if (this.isServerSide) {
            Buffer buffer = this.reader.getPacket(true);
            if (buffer.getByteAt(0) != 0) {
                throw ExceptionFactory.INSTANCE.create("expected OK packet at the end of FETCH Response not found");
            }
            buffer.skipByte();
            long rowCount = buffer.getLengthEncodedNumeric();
            this.clientEndIndex = (int)rowCount;
            this.clientStartIndex = (int)(rowCount - (long)this.dataSize + 1L);
            this.setLastRowIndex();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        if (this.protocol.isOracleMode() && this.dataSize <= 0) {
            return false;
        }
        if (!this.isServerSide) {
            return this.rowPointer == -1;
        }
        return this.currentIndex == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.protocol.isOracleMode() && this.dataSize <= 0) {
            return false;
        }
        if (!this.isServerSide) {
            return this.isLastRowSent && this.rowPointer >= this.dataSize;
        }
        return this.currentIndex == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        if (this.dataSize <= 0) {
            return false;
        }
        if (!this.isServerSide) {
            return this.rowPointer == 0;
        }
        return this.currentIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003 && this.getProtocol().isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet for oracle mode");
        }
        if (this.dataSize <= 0) {
            return false;
        }
        if (!this.isServerSide) {
            return this.isLastRowSent && this.rowPointer == this.dataSize - 1;
        }
        return this.isLastRowSent && this.currentIndex == this.lastRowIndex;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (!this.isServerSide) {
            this.rowPointer = -1;
        } else {
            this.rowPointer = -1;
            this.currentIndex = 0;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return;
        }
        if (!this.isServerSide) {
            while (!this.isLastRowSent) {
                this.cursorFetch();
            }
            this.rowPointer = this.dataSize;
        } else {
            this.rowPointer = this.dataSize;
            this.currentIndex = -1;
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            while (!this.isLastRowSent) {
                this.cursorFetch();
            }
            this.rowPointer = this.dataSize - 1;
            return this.dataSize > 0;
        }
        if (!this.isLastRowSent) {
            this.cursorFetchForOracle((byte)8, 0);
            if (this.clientStartIndex != this.clientEndIndex) {
                throw new SQLException("clientStartIndex is supposed to equal to clientEndIndex, but actually clientStartIndex is " + this.clientStartIndex + " and clientEndIndex is " + this.clientEndIndex);
            }
        }
        this.rowPointer = this.dataSize - 1;
        this.currentIndex = this.lastRowIndex;
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet: absolute");
        }
        if (row == 0 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid parameter: absolute(0)");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            if (row > 0) {
                while (!this.isLastRowSent && row > this.dataSize) {
                    this.cursorFetch();
                }
                if (row <= this.dataSize) {
                    this.rowPointer = row - 1;
                    return true;
                }
                this.afterLast();
                return false;
            }
            this.last();
            if (row >= -this.dataSize) {
                this.rowPointer = this.dataSize + row;
                return true;
            }
            this.beforeFirst();
            return false;
        }
        if (row > 0) {
            this.fetchIndex = row;
        } else {
            if (this.lastRowIndex == 0 && !this.last()) {
                return false;
            }
            this.fetchIndex = this.lastRowIndex + row + 1;
        }
        return this.fetchAbsoluteRow(this.fetchIndex);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            int newPos = this.rowPointer + rows;
            if (newPos < 0) {
                this.beforeFirst();
                return false;
            }
            return this.absolute(newPos + 1);
        }
        if (this.isAfterLast() && rows >= 0 || this.isBeforeFirst() && rows <= 0) {
            return false;
        }
        if (this.isLast() && rows > 0) {
            this.afterLast();
            return false;
        }
        if (this.isFirst() && rows < 0) {
            this.beforeFirst();
            return false;
        }
        if (this.isAfterLast() && rows < 0) {
            if (!this.last()) {
                return false;
            }
            return this.absolute(this.currentIndex + rows + 1);
        }
        return this.absolute(this.currentIndex + rows);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            if (this.rowPointer > -1) {
                --this.rowPointer;
                return this.rowPointer > -1;
            }
            return false;
        }
        if (this.isAfterLast()) {
            return this.last();
        }
        this.fetchIndex = this.currentIndex - 1;
        return this.fetchAbsoluteRow(this.fetchIndex);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClose();
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            if (this.rowPointer < this.dataSize - 1) {
                ++this.rowPointer;
                return true;
            }
            if (this.isLastRowSent) {
                this.rowPointer = this.dataSize;
                return false;
            }
            this.cursorFetch();
            ++this.rowPointer;
            return this.dataSize > this.rowPointer;
        }
        if (this.isAfterLast()) {
            return false;
        }
        this.fetchIndex = this.currentIndex + 1;
        return this.fetchAbsoluteRow(this.fetchIndex);
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (!this.isServerSide) {
            return super.getRow();
        }
        return this.currentIndex;
    }

    private boolean fetchAbsoluteRow(int fetchIndex) throws SQLException {
        if (fetchIndex < 1) {
            this.rowPointer = -1;
            this.currentIndex = 0;
            return false;
        }
        if (this.lastRowIndex < fetchIndex && this.lastRowIndex > 0) {
            this.rowPointer = this.dataSize;
            this.currentIndex = -1;
            return false;
        }
        if (this.clientStartIndex <= fetchIndex && fetchIndex <= this.clientEndIndex) {
            this.rowPointer = fetchIndex - this.clientStartIndex;
            this.currentIndex = fetchIndex;
            return true;
        }
        try {
            this.cursorFetchForOracle((byte)32, fetchIndex);
            this.rowPointer = 0;
            this.currentIndex = this.clientStartIndex;
            return this.dataSize > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

