/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.Datum;
import java.math.BigDecimal;
import java.sql.SQLException;

public class BINARY_DOUBLE
extends Datum {
    public static final boolean TRACE = false;

    public BINARY_DOUBLE() {
    }

    public BINARY_DOUBLE(byte[] bytes) {
        super(bytes);
    }

    public BINARY_DOUBLE(double doubleVal) {
        super(BINARY_DOUBLE.doubleToCanonicalFormatBytes(doubleVal));
    }

    public BINARY_DOUBLE(Double doubleVal) {
        super(BINARY_DOUBLE.doubleToCanonicalFormatBytes(doubleVal));
    }

    public BINARY_DOUBLE(String stringVal) throws SQLException {
        this(BINARY_DOUBLE.stringToDouble(stringVal));
    }

    public BINARY_DOUBLE(Boolean booleanVal) {
        this(booleanVal != false ? 1 : 0);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return new Double(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
    }

    @Override
    public boolean isConvertibleTo(Class targetClass) {
        String className = targetClass.getName();
        return className.compareTo("java.lang.String") == 0 || className.compareTo("java.lang.Double") == 0;
    }

    @Override
    public String stringValue() {
        return Double.toString(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
    }

    @Override
    public double doubleValue() throws SQLException {
        return BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes());
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return new BigDecimal(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
    }

    @Override
    public Object makeJdbcArray(int intVal) {
        return new Double[intVal];
    }

    private static double stringToDouble(String stringVal) throws SQLException {
        return Double.valueOf(stringVal);
    }

    static byte[] doubleToCanonicalFormatBytes(double doubleVal) {
        int pos8;
        double doubleValTmp = doubleVal;
        if (doubleVal == 0.0) {
            doubleValTmp = 0.0;
        } else if (doubleVal != doubleVal) {
            doubleValTmp = Double.NaN;
        }
        long longVal = Double.doubleToLongBits(doubleValTmp);
        byte[] bytes = new byte[8];
        int intPart1 = (int)longVal;
        int intPart2 = (int)(longVal >> 32);
        int pos1 = intPart1;
        int pos2 = intPart1 >>= 8;
        int pos3 = intPart1 >>= 8;
        int pos4 = intPart1 >>= 8;
        int pos5 = intPart2;
        int pos6 = intPart2 >>= 8;
        int pos7 = intPart2 >>= 8;
        if (((intPart2 >>= 8) & 0x80) == 0) {
            pos8 = intPart2 | 0x80;
        } else {
            pos8 = ~intPart2;
            pos7 ^= 0xFFFFFFFF;
            pos6 ^= 0xFFFFFFFF;
            pos5 ^= 0xFFFFFFFF;
            pos4 = ~intPart1;
            pos3 ^= 0xFFFFFFFF;
            pos2 ^= 0xFFFFFFFF;
            pos1 ^= 0xFFFFFFFF;
        }
        bytes[7] = (byte)pos1;
        bytes[6] = (byte)pos2;
        bytes[5] = (byte)pos3;
        bytes[4] = (byte)pos4;
        bytes[3] = (byte)pos5;
        bytes[2] = (byte)pos6;
        bytes[1] = (byte)pos7;
        bytes[0] = (byte)pos8;
        return bytes;
    }

    static double canonicalFormatBytesToDouble(byte[] bytes) {
        int intPos8;
        int intPos7;
        int intPos6;
        int intPos5;
        int intPos4;
        int intPos3;
        int intPos2;
        int intPos1;
        if ((bytes[0] & 0x80) != 0) {
            intPos1 = bytes[0] & 0x7F;
            intPos2 = bytes[1] & 0xFF;
            intPos3 = bytes[2] & 0xFF;
            intPos4 = bytes[3] & 0xFF;
            intPos5 = bytes[4] & 0xFF;
            intPos6 = bytes[5] & 0xFF;
            intPos7 = bytes[6] & 0xFF;
            intPos8 = bytes[7] & 0xFF;
        } else {
            intPos1 = ~bytes[0] & 0xFF;
            intPos2 = ~bytes[1] & 0xFF;
            intPos3 = ~bytes[2] & 0xFF;
            intPos4 = ~bytes[3] & 0xFF;
            intPos5 = ~bytes[4] & 0xFF;
            intPos6 = ~bytes[5] & 0xFF;
            intPos7 = ~bytes[6] & 0xFF;
            intPos8 = ~bytes[7] & 0xFF;
        }
        int longPos1 = intPos1 << 24 | intPos2 << 16 | intPos3 << 8 | intPos4;
        int longPos2 = intPos5 << 24 | intPos6 << 16 | intPos7 << 8 | intPos8;
        long longVal = (long)longPos1 << 32 | (long)longPos2 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(longVal);
    }
}

