/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.ExceptionInterceptor;
import com.oceanbase.jdbc.Lob;
import com.oceanbase.jdbc.ObClob;
import com.oceanbase.jdbc.ObLobLocator;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Arrays;

public class Clob
extends Lob
implements ObClob {
    private static final long serialVersionUID = -3066501059817815286L;
    private static int maxLength = 0x40000000;
    String Clob_0 = "indexToWriteAt must be >= 1";
    String Clob_1 = "indexToWriteAt must be >= 1";
    String Clob_2 = "Starting position can not be < 1";
    String Clob_3 = "String to set can not be NULL";
    String Clob_4 = "Starting position can not be < 1";
    String Clob_5 = "String to set can not be NULL";
    String Clob_6 = "CLOB start position can not be < 1";
    String Clob_7 = "CLOB start position + length can not be > length of CLOB";
    String Clob_8 = "Illegal starting position for search, '";
    String Clob_9 = "'";
    String Clob_10 = "Starting position for search is past end of CLOB";
    String Clob_11 = "Cannot truncate CLOB of length";
    String Clob_12 = "\\\\ to length of";
    String Clob_13 = ".";

    public Clob(byte[] bytes) {
        super(bytes);
        this.encoding = Charset.defaultCharset().name();
    }

    public static Clob getEmptyCLOB() throws SQLException {
        byte[] emptyData = new byte[40];
        emptyData[0] = 33;
        emptyData[1] = 66;
        emptyData[2] = 79;
        emptyData[3] = 76;
        emptyData[4] = 1;
        return new Clob(true, emptyData, Charset.defaultCharset().name(), null);
    }

    public Clob(byte[] bytes, ExceptionInterceptor exceptionInterceptor) {
        super(bytes, exceptionInterceptor);
        this.encoding = Charset.defaultCharset().name();
    }

    public Clob(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
        this.encoding = Charset.defaultCharset().name();
    }

    public Clob(String charDataInit, ExceptionInterceptor exceptionInterceptor) {
        this.charData = charDataInit;
        this.exceptionInterceptor = exceptionInterceptor;
        this.encoding = Charset.defaultCharset().name();
    }

    public Clob(boolean hasLocator, byte[] data, String encoding, OceanBaseConnection conn) throws SQLException {
        if (!hasLocator) {
            this.encoding = encoding;
            try {
                this.charData = new String(data, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unsupported character encoding");
            }
        }
        if (null != data) {
            Buffer buffer = new Buffer(data);
            this.encoding = encoding;
            if (buffer.getLimit() >= ObLobLocator.OB_LOG_LOCATOR_HEADER) {
                this.locator = new ObLobLocator();
                this.locator.magicCode = buffer.readLongV1();
                this.locator.version = buffer.readLongV1();
                this.locator.snapshotVersion = buffer.readLongLongV1();
                this.locator.tableId = buffer.getBytes(8);
                this.locator.columnId = buffer.readLongV1();
                this.locator.flags = buffer.readIntV1();
                this.locator.option = buffer.readIntV1();
                this.locator.payloadOffset = buffer.readLongV1();
                this.locator.payloadSize = buffer.readLongV1();
                this.locator.binaryData = buffer.getByteBuffer();
                if (this.locator.payloadSize + this.locator.payloadOffset <= (long)(buffer.getLimit() - ObLobLocator.OB_LOG_LOCATOR_HEADER) && conn != null) {
                    this.locator.rowId = buffer.getBytes((int)this.locator.payloadOffset);
                    this.locator.connection = conn;
                    try {
                        if ((int)this.locator.payloadSize > maxLength) {
                            throw new SQLException("Exceed max length of Clob for support " + maxLength + " current " + this.locator.payloadSize);
                        }
                        this.charData = new String(buffer.getBytes((int)((long)ObLobLocator.OB_LOG_LOCATOR_HEADER + this.locator.payloadOffset), (int)this.locator.payloadSize), this.encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SQLException("Unsupported character encoding " + this.encoding);
                    }
                }
            }
        }
    }

    public Clob() {
        this.encoding = Charset.defaultCharset().name();
    }

    @Override
    public synchronized ObLobLocator getLocator() {
        return this.locator;
    }

    @Override
    public synchronized void setLocator(ObLobLocator locator) {
        if (this.locator == null) {
            this.locator = new ObLobLocator();
        }
        this.locator.columnId = locator.columnId;
        this.locator.flags = locator.flags;
        this.locator.magicCode = locator.magicCode;
        this.locator.option = locator.option;
        this.locator.snapshotVersion = locator.snapshotVersion;
        this.locator.tableId = locator.tableId;
        this.locator.rowId = locator.rowId;
        this.locator.version = locator.version;
        this.locator.payloadOffset = locator.payloadOffset;
        this.locator.payloadSize = locator.payloadSize;
        this.locator.binaryData = locator.binaryData;
    }

    public String toString() {
        if (this.charData != null) {
            return this.charData;
        }
        Charset charset = Charset.forName(this.encoding);
        return new String(this.data, this.offset, this.length, charset);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("position must be >= 1");
        }
        if (length < 0) {
            throw ExceptionFactory.INSTANCE.create("length must be > 0");
        }
        int adjustedStartPos = (int)pos - 1;
        int adjustedEndIndex = adjustedStartPos + length;
        if (this.charData != null) {
            if (adjustedEndIndex > this.charData.length()) {
                adjustedEndIndex = this.charData.length();
            }
            return this.charData.substring(adjustedStartPos, adjustedEndIndex);
        }
        try {
            String val = this.toString();
            return val.substring((int)pos - 1, Math.min((int)pos - 1 + length, val.length()));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Reader getCharacterStream() {
        if (this.charData != null) {
            return new StringReader(this.charData);
        }
        return new StringReader(this.toString());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        String val = this.toString();
        if ((long)val.length() < (long)((int)pos - 1) + length) {
            throw ExceptionFactory.INSTANCE.create("pos + length is greater than the number of characters in the Clob");
        }
        String sub = val.substring((int)pos - 1, (int)pos - 1 + (int)length);
        return new StringReader(sub);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        int bytePosition = this.utf8Position((int)pos - 1);
        OutputStream stream = this.setBinaryStream(bytePosition + 1);
        try {
            return new OutputStreamWriter(stream, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unsupported character encoding " + this.encoding);
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.charData != null) {
            try {
                if (this.encoding != null) {
                    return new ByteArrayInputStream(this.charData.getBytes(this.encoding));
                }
                return new ByteArrayInputStream(this.charData.getBytes());
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unsupported character encoding " + this.encoding);
            }
        }
        return this.getBinaryStream();
    }

    @Override
    public long position(String searchStr, long start) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Illegal starting position for search, '" + start + "'");
        }
        if (start - 1L > (long)this.toString().length()) {
            throw new SQLException("Cannot truncate CLOB of length ");
        }
        long pos = this.toString().indexOf(searchStr, (int)start - 1);
        return pos == -1L ? -1L : pos + 1L;
    }

    @Override
    public long position(java.sql.Clob searchStr, long start) throws SQLException {
        return this.position(searchStr.toString(), start);
    }

    private int utf8Position(int charPosition) {
        int pos = this.offset;
        for (int i = 0; i < charPosition; ++i) {
            int byteValue = this.data[pos] & 0xFF;
            if (byteValue < 128) {
                ++pos;
                continue;
            }
            if (byteValue < 194) {
                throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
            }
            if (byteValue < 224) {
                pos += 2;
                continue;
            }
            if (byteValue < 240) {
                pos += 3;
                continue;
            }
            if (byteValue < 248) {
                pos += 4;
                continue;
            }
            throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
        }
        return pos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int setString(long pos, String str) throws SQLException {
        if (this.locator != null) {
            try {
                this.updateClobToServer(pos, str.getBytes(this.encoding), 0, str.length());
                return 0;
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unsupported character encoding " + this.encoding);
            }
        }
        int bytePosition = this.utf8Position((int)pos - 1);
        try {
            super.setBytes(bytePosition + 1 - this.offset, str.getBytes(this.encoding));
            return str.length();
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unsupported character encoding " + this.encoding);
        }
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (pos < 1L) {
            throw new SQLException(this.Clob_4);
        }
        if (str == null) {
            throw new SQLException(this.Clob_5);
        }
        try {
            return this.setString(pos, str.substring(offset, offset + len));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.setBinaryStream(this.utf8Position((int)pos - 1) + 1);
    }

    @Override
    public long length() {
        if (this.charData != null) {
            return this.charData.length();
        }
        Charset charset = Charset.forName(this.encoding);
        if (!charset.equals(StandardCharsets.UTF_8)) {
            return this.toString().length();
        }
        long len = 0L;
        int pos = this.offset;
        while (len < (long)this.length && this.data[pos] >= 0) {
            ++len;
            ++pos;
        }
        while (pos < this.offset + this.length) {
            byte firstByte;
            if ((firstByte = this.data[pos++]) < 0) {
                if (firstByte >> 5 != -2 || (firstByte & 0x1E) == 0) {
                    if (firstByte >> 4 == -2) {
                        if (pos + 1 < this.offset + this.length) {
                            pos += 2;
                            ++len;
                            continue;
                        }
                        throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                    }
                    if (firstByte >> 3 != -2) {
                        throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                    }
                    if (pos + 2 < this.offset + this.length) {
                        pos += 3;
                        len += 2L;
                        continue;
                    }
                    pos += this.offset + this.length;
                    ++len;
                    continue;
                }
                ++pos;
                ++len;
                continue;
            }
            ++len;
        }
        return len;
    }

    @Override
    public void truncate(long truncateLen) throws SQLException {
        if (this.locator != null) {
            if (this.length > this.charData.length()) {
                throw new SQLException("Clob length is more than charData length");
            }
            if (this.locator == null) {
                this.charData = this.charData.substring(0, (int)truncateLen);
            } else {
                this.trimClobToServer((int)truncateLen);
            }
            return;
        }
        long len = 0L;
        int pos = this.offset;
        while (len < (long)this.length && len < truncateLen && this.data[pos] >= 0) {
            ++len;
            ++pos;
        }
        while (pos < this.offset + this.length && len < truncateLen) {
            byte firstByte;
            if ((firstByte = this.data[pos++]) < 0) {
                if (firstByte >> 5 != -2 || (firstByte & 0x1E) == 0) {
                    if (firstByte >> 4 == -2) {
                        if (pos + 1 < this.offset + this.length) {
                            pos += 2;
                            ++len;
                            continue;
                        }
                        throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                    }
                    if (firstByte >> 3 != -2) {
                        throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                    }
                    if (pos + 2 < this.offset + this.length) {
                        if (len + 2L <= truncateLen) {
                            pos += 3;
                            len += 2L;
                            continue;
                        }
                        ++pos;
                        len = truncateLen;
                        continue;
                    }
                    throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                }
                ++pos;
                ++len;
                continue;
            }
            ++len;
        }
        this.length = pos - this.offset;
    }

    @Override
    public synchronized void updateClobToServer(long writeAt, byte[] bytes, int offset, int length) throws SQLException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        CallableStatement cstmt = this.locator.connection.prepareCall("{call DBMS_LOB.write( ?, ?, ?, ?)}");
        cstmt.setClob(1, (java.sql.Clob)this);
        cstmt.setInt(2, length);
        cstmt.setInt(3, (int)writeAt);
        try {
            cstmt.setString(4, new String(bytes, this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        cstmt.registerOutParameter(1, 2005);
        cstmt.execute();
        Clob r = (Clob)cstmt.getClob(1);
        if (r == null || r.getLocator() == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        this.setLocator(r.locator);
        this.data = r.data;
        int from = (int)((long)ObLobLocator.OB_LOG_LOCATOR_HEADER + this.locator.payloadOffset);
        int to = (int)((long)from + this.locator.payloadSize);
        this.encoding = r.encoding;
        try {
            this.charData = new String(Arrays.copyOfRange(r.locator.binaryData, from, to), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unsupported character encoding " + this.encoding);
        }
    }

    public synchronized void trimClobToServer(int len) throws SQLException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        CallableStatement cstmt = this.locator.connection.prepareCall("{call DBMS_LOB.trim( ?, ?)}");
        cstmt.setClob(1, (java.sql.Clob)this);
        cstmt.setInt(2, len);
        cstmt.registerOutParameter(1, 2005);
        cstmt.execute();
        Clob r = (Clob)cstmt.getClob(1);
        if (r == null || r.getLocator() == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        this.setLocator(r.locator);
        this.data = r.data;
        int from = (int)((long)ObLobLocator.OB_LOG_LOCATOR_HEADER + this.locator.payloadOffset);
        int to = (int)((long)from + this.locator.payloadSize);
        this.encoding = r.encoding;
        try {
            this.charData = new String(Arrays.copyOfRange(r.locator.binaryData, from, to), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unsupported character encoding " + this.encoding);
        }
    }
}

