function getContextPath() {
    var pathName = document.location.pathname;
    var index = pathName.substr(1).indexOf("/");
    var result = pathName.substr(0, index + 1);
    return result;
}

function judgeEmpty(obj) {
    return obj == undefined || obj.length == 0;
}

function judgeNotEmpty(obj) {
    return !judgeEmpty(obj);
}

//require.js配置
require.config({
    urlArgs: function () {
        var date = new Date();
        var year = date.getFullYear();
        var month = date.getMonth() + 1;
        var day = date.getDate();
        if (month < 10) {
            month = "0" + month;
        }
        if (day < 10) {
            day = "0" + day;
        }
        return "?bust=" + year + month + day;
    },
    baseUrl: getContextPath() + '/scripts',
    paths: {
        'jquery': [getContextPath() + '/libs/jquery/jquery.min'],
        'jquery-ui': [getContextPath() + '/libs/jquery-ui/jquery-ui.min'],
         'vue': [getContextPath() + '/libs/vue/vue'],   //开发环境
        //'vue': [getContextPath() + '/libs/vue/vue.min'],   //生产环境
        'layer': [getContextPath() + '/libs/layer/layer'],
        'freeze-table': [getContextPath() + '/libs/jquery-freeze-table/freeze-table.min'],
        'My97DatePicker': [getContextPath() + '/libs/My97DatePicker/WdatePicker'],
        'jquery-ztree': [getContextPath() + '/libs/jquery.ztree/js/jquery.ztree.all'],
        'jquery-serializejson': [getContextPath() + '/libs/jquery.serializeJSON/jquery.serializejson.min'],
        'webuploader': [getContextPath() + '/libs/webuploader/js/webuploader.min'],
        'CKEditor': [getContextPath() + '/libs/ckeditor/ckeditor'],
        'jquery-qtip': [getContextPath() + '/libs/jquery.qtip/jquery.qtip.min'],
        'echarts': [getContextPath() + '/libs/echarts/echarts.min'],
        'moment': [getContextPath() + '/libs/moment/moment'],
        'ELEMENT': [getContextPath() + '/libs/element-ui/element-ui'],
        'wangEditor':[getContextPath() + '/libs/wangEditor/release/wangEditor'],
        'jsPDF': [getContextPath() + '/libs/jsPDF/jspdf.debug'],
        'html2canvas': [getContextPath() + '/libs/jsPDF/html2canvas'],
        'Base64': [getContextPath() + '/libs/jsPDF/base64'],
        // ie兼容es6语法
        'polyfill': [getContextPath() + '/libs/jsPDF/polyfill'],
        'Popper': [getContextPath() + '/libs/popper/popper-x'],
        'component-demo-image': ['./component-demo-image'],
        'component-demo-image-new': ['./component-demo-image-new'],
        'marked':[getContextPath() + '/libs/marked/marked.umd.min'],
        'markdown':[getContextPath() + '/libs/marked/markdown-it.min'],
        //流程引擎组件
        'process-engine-toolbar-v2': [getContextPath() + '/libs/process-engine/component-process-engine-toolbar-v2'],
        'process-engine-toolbar-v3': [getContextPath() + '/libs/process-engine/component-process-engine-toolbar-v3'],
        'process-engine-debug': [getContextPath() + '/libs/process-engine/component-process-engine-debug'],
        'peac-history': [getContextPath() + '/libs/process-engine/component-peac-history'],
        'peac-history-v2': [getContextPath() + '/libs/process-engine/component-peac-history-v2'],
        'peac-show-history': [getContextPath() + '/libs/process-engine/component-peac-show-history'],
        'process-engine-history-extend': [getContextPath() + '/libs/process-engine/process-engine-history-extend'],
        'process-engine-history-extend-v2': [getContextPath() + '/libs/process-engine/process-engine-history-extend-v2'],
        'peac-test': [getContextPath() + '/libs/process-engine/component-peac-test'],
        'peac-user': [getContextPath() + '/libs/process-engine/component-peac-user'],
        'peac-manager': [getContextPath() + '/libs/process-engine/component-peac-manager'],
        'peac-user-tree': [getContextPath() + '/libs/process-engine/component-peac-user-tree'],
        'peac-users-tree': [getContextPath() + '/libs/process-engine/component-peac-users-tree'],

        'peac-base-user': [getContextPath() + '/libs/process-engine/component-peac-base-user'],
        'peac-base-users': [getContextPath() + '/libs/process-engine/component-peac-base-users'],
        'pick-script-judge-user': [getContextPath() + '/libs/process-engine/component-pick-script-judge-user'],
        'pick-cmcc-id-user': [getContextPath() + '/libs/process-engine/component-pick-cmcc-id-user'],
        'pick-employee-id-user': [getContextPath() + '/libs/process-engine/component-pick-employee-id-user'],
        'pick-cmcc-role-user': [getContextPath() + '/libs/process-engine/component-pick-cmcc-role-user'],
        'peac-script-user-picker': [getContextPath() + '/libs/process-engine/component-peac-script-user-picker'],
        'peac-url-user-picker': [getContextPath() + '/libs/process-engine/component-peac-url-user-picker'],
        'peac-url-users-picker': [getContextPath() + '/libs/process-engine/component-peac-url-users-picker'],
    },
    shim: {
        'jquery-ui': {
            deps: ['jquery', 'css!' + getContextPath() + '/libs/jquery-ui/jquery-ui.min.css']
        },
        'freeze-table': {
            deps: ['jquery']
        },
        'layer': {
            deps: ['jquery', 'css!' + getContextPath() + '/libs/layer/theme/default/layer.css']
            //, exports: 'layer'
        },
        'My97DatePicker': {
            exports: 'WdatePicker'
        },
        'jquery-ztree': {
            deps: ['jquery'
                //, 'css!' + getContextPath() + '/libs/jquery.ztree/css/awesomeStyle/awesome.css'
                //, 'css!' + getContextPath() + '/libs/jquery.ztree/css/metroStyle/metroStyle.css'
                , 'css!' + getContextPath() + '/libs/jquery.ztree/css/zTreeStyle/zTreeStyle.css'
            ]
        },
        'jquery-serializejson': {
            deps: ['jquery']
        },
        'webuploader': {
            deps: ['jquery', 'css!' + getContextPath() + '/libs/webuploader/css/webuploader.css']
        },
        'component-connection-box': {
            deps: ['css!' + getContextPath() + '/styles/connection-box.css']
        },
        'jquery-qtip': {
            deps: ['jquery', 'css!' + getContextPath() + '/libs/jquery.qtip/jquery.qtip.min.css']
        },
        'peac-user-tree': {
            deps: ['css!' + getContextPath() + '/styles/process-engine/component-peac.css']
        },
        'peac-users-tree': {
            deps: ['css!' + getContextPath() + '/styles/process-engine/component-peac.css']
        },
        'jsPDF': {
            deps: ['html2canvas', 'Base64', 'polyfill']
        },
        'Popper': {
            deps: ['polyfill']
        },
        'ELEMENT': {
            deps: ['css!' + getContextPath() + '/libs/element-ui/element-ui.css'],
        },
        'wangEditor': {
            deps: ['css!' + getContextPath() + '/libs/wangEditor/release/wangEditor.css'],
        }
    },
    map: {
        '*': {
            'css': getContextPath() + '/libs/require-css/css.min.js'
        }
    },
    waitSeconds: 0  //修复Load timeout for modules错误
});

//定义公共模块，应用程序中引用后会自动引用对应依赖模块
define("global",
    [
        'css!' + getContextPath() + '/styles/font_1520246_i31tm8otbyq/iconfont',
        'jquery',
        'jquery-ui',
        'vue',
        'layer',
        'My97DatePicker',
        'jquery-ztree',
        'jquery-serializejson',
        'webuploader',
        'CKEditor',
        'moment',
        'jquery-qtip',
        'ELEMENT',
        'common-config',

        // 'wangEditor',
        //'lodop',
        //以上模块根据paths及shim配置加载

        //以下模块根据baseUrl配置自动加载
        'common',                       //公用脚本
        'utils',                        //工具类
        'ajax-global',                  //ajax全局配置

        'component-ckeditor',           //CKEditor富文本编辑器
        'component-uploader',           //上传组件
        'component-files',              //文件查看组件
        'component-files-detail',       //文件查看组件-a标签
        'component-datepicker',         //日期组件
        'component-datetimepicker',     //日期时间组件
        'component-fuzzy-query-select',  //模糊查询
        'component-pagination',         //分页组件
        'component-popup-input',        //通用PopupInput组件
        'component-input-number',       //数字选择组件
        'component-excel-import',       //导入组件
        'component-connection-box',     //多级关联选择框组件
        'component-popup-uploader',     //弹窗上传组件
        'component-uploader-files',     //弹窗上传组件-表格模式
        'component-select-tree',        //树形选择框
        'component-jump-home',        //跳转首页
        'directive-only-num',           //限制输入数字
        'directive-dialog-drag',           //限制输入数字
        'to-thousands',                 //金额转千分位
        'XMLHttp-download-file', //下载文件前校验
        'component-demo-image', //显示图片
        'component-checkbox-list',     //复选框
        'marked',
        'markdown',
        //'component-demo-image-new',
       // 'directive-ellipsis',           //显示更多文字

        //流程引擎选人组件
        'process-engine-toolbar-v2',
        'process-engine-toolbar-v3',
        'process-engine-debug',
        //'process-engine-config',        //流程引擎配置
        'process-engine-history-extend',
        'process-engine-history-extend-v2',
        'peac-history',
        'peac-history-v2',
        'peac-show-history',
        'peac-test',
        'peac-user',
        'peac-manager',
        'peac-user-tree',
        'peac-users-tree',

        'pick-script-judge-user',
        'pick-cmcc-id-user',
        'pick-employee-id-user',
        'pick-cmcc-role-user',
        'peac-script-user-picker',
        'peac-url-user-picker',
        'peac-url-users-picker',
    ]);

