//图片展示组件
define(['jquery', 'vue'], function ($, Vue) {
    return Vue.component('component-demo-image-new', {
        template: '<div class="demo_img_body_new" @mouseleave.stop="mouseLeave()">\
                     <img style="width:100%;height: 100%" :src="thumbnailImg" @mouseenter.stop="mouseEnter()">\
                     <div v-if="isShow" :class="isShow == true ? \'hidden_img_div_new open_play\':\'hidden_img_div_new close_play\'">\
                         <img class="hidden_img" :src="chooseImg" @click="downloadFile(chooseImg)">\
                     </div>\
                   </div>',
        props: {
            showImg:{default: ''},
            imgIndex:{default:null},
        },
        data: function () {
            return {
               chooseImg:'',
               isShow:false,
               thumbnailImg:'',
            }
        },
        computed: {

        },
        watch: {
        },
        created: function () {
            this.thumbnailImg = fileStoreServer + '/thumbnail/'+this.showImg+'?areaWidth=1080&areaHeight=1920';
        },
        mounted: function () {
        },
        methods: {
            mouseEnter:function(){
                this.chooseImg = this.thumbnailImg;
                this.isShow = true;
            },
            mouseLeave:function(index){
                this.chooseImg = '';
                this.isShow = false;
            },
            downloadFile:function(url){
              const link = document.createElement('a');
              fetch(url).then(res => res.blob()).then((blob) => {
                link.href = URL.createObjectURL(blob);
                link.download = '';
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
              });
            }
            //模拟表单下载文件
            // downloadFile: function (imageId) {
            //     $.ajax({
            //         async: false,
            //         type: 'GET',
            //         url: fileStoreServer + '/api/get/' + imageId,
            //         contentType: 'application/json',
            //         success: function (data) {
            //             if (!data.isSuccess) return;
            //             var url = fileStoreServer + "/api/download/" + imageId;
            //             var fileName = data.data.fullname;
            //             var form = $("<form></form>").attr("action", url).attr("method", "GET");
            //             form.append($("<input></input>").attr("type", "hidden").attr("name", "fileName").attr("value", fileName));
            //             form.appendTo('body').submit().remove();
            //         }
            //     });
            // }
        }
    });
});