//通用脚本
require(['jquery', 'layer', 'jquery-qtip'], function ($, layer) {

    //解决IE8、IE9不支持console问题
    window.console = window.console || (function () {
        var c = {};
        c.log = c.warn = c.debug = c.info = c.error = c.time = c.dir = c.profile
            = c.clear = c.exception = c.trace = c.assert = function () {
        };
        return c;
    })();

    //为a链接添加标签打开支持
    //$(function () {
    //判断是否在框架页中
    var w = self;
    if (self != top) w = top;
    $(document).on('click', 'a[tab]', function (e) {
        //先加载common.js，main.html页面的mainApp还未生成，故要在放在内部判断
        if (w.mainApp) {
            if (e.ctrlKey) {
                return;
            }
            var title = $(this).attr('tabTitle');
            if (title == undefined)
                title = $(this).text();
            var tabId = $(this).attr('tabId');
            var url = $(this).attr('href');
            w.mainApp.openTab(title, url, tabId);
            e.preventDefault();
        }
    });
    //});

    //checkbox-menu弹出层点击时阻止事件冒泡
    $(document).on('click', '.checkbox-menu', function (e) {
        e.stopPropagation();
    });

    //添加了fixed样式的page_title在页面滚动时固定在头部
    $(window).scroll(function () {
        //当页面中只有一个page_title时才触发此效果
        if ($('.page_title').length == 1) {
            var top = $('.page_title').offset().top;
            if ($(window).scrollTop() >= top) {
                $('.page_title.fixed').addClass('page_title_fixed');
            }
            if ($(window).scrollTop() == 0) {
                $('.page_title.fixed').removeClass('page_title_fixed');
            }
        }
    });

    //Javascript方式无法为Vue组件内添加tooltip图标，改用css方式添加
    //$('.tooltip_icon').append(' <span class="glyphicon glyphicon-info-sign" style="color: #3498db;"></span>');
    //设置qtip的z-index在最上层，否则在layer弹出层中无法显示
    // qtip参考网址：https://www.cnblogs.com/piuba/archive/2012/07/04/2575700.html
    $.fn.qtip.zindex = 2147483647;
    //qtip提示
    $(document).on('mouseover', '.tooltip', function (event) {
        var position = $(this).attr('qtip-position'); // qtip-position="top left,bottom left"
        var my = 'bottom left';
        var at = 'top left';
        if (position) {
            my = position.split(',')[0];
            at = position.split(',')[1];
        }
        $(this).qtip({
            overwrite: false,
            show: {
                event: event.type,
                ready: true
            },
            position: {
                //viewport: $(window),
                // 如提示的目标元素(at属性)
                // 对应 提示信息(my属性)
                my: my,
                at: at,
            },
            style: {
                classes: 'qtip-bootstrap'
            }
        }, event);
    });

    // 统一添加required * 样式
    $(document).find('.required').each(function () {
        $(this).append('<i>*</i>')
    });
    /*layer 拓展css样式*/
    layer.config({
        extend: 'myskin/style.css',
        shade: [.35]
    });
    // 返回首页
    $(document).on('click', '.btn_go_home', function () {
        window.location.href = '../pages/main/main-it.html'
    });
    // 普通的表格动态显示滚动条， 鼠标移入显示滚动条，移出隐藏
    /*$(document).on('mouseenter','.table_overflow', function () {
        console.log('table_overflow', $(this).width())
        console.log('table_list', $(this).find('.table_list').width())

        var width = $(this).width()
        var height = $(this).height()
        var tableListHeight = $(this).find('.table_list').height()
        $(this).addClass('hover')
        // ie浏览器、edge浏览器
        if (navigator.userAgent.indexOf("Edge") > -1 || (!!window.ActiveXObject || "ActiveXObject" in window)) {
            $(this).find('.table_list').width($(this).width() - 1)
        } else {
            $(this).find('.table_list').width($(this).width() - 2)
        }
    })
    /!*console.log($(this).width())
    console.log($(this).find('.table_list').width())*!/
    $(document).on('mouseleave','.table_overflow', function () {
        $(this).removeClass('hover')
        $(this).find('.table_list').removeAttr('style')
    })*/

    // element-ui 表格动态显示滚动条， 鼠标移入显示滚动条，移出隐藏
    $(document).on('mouseenter', '.el-table--scrollable-y', function () {
        $(this).find('.el-table__body-wrapper').css({'overflow-y': 'auto'})
    })
    $(document).on('mouseleave', '.el-table--scrollable-y', function () {
        $(this).find('.el-table__body-wrapper').css({'overflow-y': 'hidden'})
    })

    // Js toFixed()四舍五入BUG的解决方法
    Number.prototype.toFixed=function (fractionDigits) {
        var s=this+"";
        var d = parseInt(fractionDigits)
        if(!d)d=0;
        if(s.indexOf(".")==-1)s+=".";
        s+=new Array(d+1).join("0");
        if(new RegExp("^(-|\\+)?(\\d+(\\.\\d{0,"+(d+1)+"})?)\\d*$").test(s)){
            var s="0"+RegExp.$2,pm=RegExp.$1,a=RegExp.$3.length,b=true;
            if(a==d+2){
                a=s.match(/\d/g);
                if(parseInt(a[a.length-1])>4){
                    for(var i=a.length-2;i>=0;i--){
                        a[i]=parseInt(a[i])+1;
                        if(a[i]==10){
                            a[i]=0;
                            b=i!=1;
                        }else break;
                    }
                }
                s=a.join("").replace(new RegExp("(\\d+)(\\d{"+d+"})\\d$"),"$1.$2");

            }if(b)s=s.substr(1);
            return (pm+s).replace(/\.$/,"");
        }return this+"";

    };

});

