//流程引擎组件v2
define(['jquery', 'vue', 'layer'], function ($, Vue, layer) {
    return Vue.component('process-engine-toolbar-v3', {
        template: '<div style="margin: 10px;text-align: center;">\
            <!--流程发起-->\
            <template v-if="!runtimeProcessId">\
                <button type="button" class="btn btn_primary" @click="openActionPanel" v-if="pendingActivities.length>0"><i class="iconfont icon-next"></i>提交下一步处理</button>\
                <button type="button" class="btn btn_primary" @click="openDeployDiagram"><i class="iconfont icon-process"></i>流程图</button>\
            </template>\
            <!--流程处理-->\
            <template v-if="runtimeProcessId">\
                <select class="form_control" @change="selectActivity($event)" v-if="pendingActivities.length>1">\
                    <option value="" v-for="item in pendingActivities">{{item.name}}</option>\
                </select>\
                <button type="button" class="btn btn_primary" @click="openActionPanel" v-if="pendingActivities.length>0"><i class="iconfont icon-next"></i>处理</button>\
                <button type="button" class="btn btn_primary" @click="openDeliverPanel" v-if="currentActivity.allowDeliver"><i class="iconfont icon-zhuanjiao"></i>转交</button>\
                <button type="button" class="btn btn_primary" @click="openReturnPanel" v-if="currentActivity.returns!=undefined&&currentActivity.returns.length>0"><i class="iconfont icon-back"></i>退回</button>\
                <button type="button" class="btn btn_primary" @click="openTakeBackPanel" v-if="takeBacks!=undefined&&takeBacks.length>0"><i class="iconfont icon-chehui"></i>撤回</button>\
                <button type="button" class="btn btn_primary" @click="openStopPanel" v-if="currentActivity.allowStop">终止</button>\
                <button type="button" class="btn btn_primary" @click="openRuntimeDiagram"><i class="iconfont icon-process"></i>流程图</button>\
            </template>\
            <!--流程处理面板-->\
            <div class="block_container" id="processEngineActionPanel" style="display: none;">\
                <div class="content" v-if="(currentActivity.actions != undefined && currentActivity.actions.length > 1) || additionalControl != \'\'||actionExtendControl!=\'\'"  style="padding: 14px 10px 0;">\
                    <keep-alive>\
                        <component :is="actionExtendControl" ref="actionExtendControl" style="padding-bottom: 10px;"></component>\
                    </keep-alive>\
                    <div class="peac_column peac_column_action" v-if="currentActivity.actions.length > 1||additionalControl != \'\'">\
                        <div class="peac_action_item" v-bind:class="{ \'peac_action_item_selected\': item.nextActivityId == currentAction.nextActivityId }"\
                         v-for="(item, index) in currentActivity.actions" @click="selectAction(item)">\
                            <i :class="itemAddClass(item)"></i>{{item.name}}\
                         </div>\
                    </div>\
                    <div class="peac_column peac_component" v-if="currentActivity.actions.length > 1||additionalControl != \'\'">\
                        <keep-alive>\
                            <component :is="additionalControl" :description="peacDescription" ref="additionalControl"></component>\
                        </keep-alive>\
                        <div class="peac_component_empty" v-if="currentActivity.actions.length > 1&&additionalControl == \'\'">{{currentAction.description}} 无需选择处理人。</div>\
                    </div>\
                    <br class="clear_both">\
                </div>\
                <div class="content" v-if="currentAction.commentRequired != null" style="padding: 10px 10px 0;">\
                    <div class="form_group">\
                        <div class="comment_toolbar">\
                            <span>请输入常用意见</span>\
                            <button type="button" class="btn btn_agree" @click="quickComment">同意</button>\
                            <select class="form_control"\
                                @change="selectComment($event)">\
                                <option value="">常用处理意见</option>\
                                <option :value="item.comment" v-for="item in comments">{{item.comment}}</option>\
                            </select>\
                            <label>\
                                <input type="checkbox" v-model="saveComment"> 保存为常用意见\
                            </label>\
                            <button type="button" class="btn btn_info" @click="openCommentPanel">编辑常用意见</button>\
                            <br class="clear_both">\
                        </div>\
                        <textarea class="form_control comment_textarea" rows="3" v-model="comment" placeholder="请在此输入意见!" style=""></textarea>\
                    </div>\
                </div>\
                <div class="peac_tips" v-if="currentActivity.actions.length == 1 && additionalControl == \'\' && currentAction.commentRequired == null">\
                    确定提交流程吗？\
                </div>\
            </div>\
            <!--流程转交-->\
            <div id="processEngineDeliverPanel" style="display: none; margin: 10px; color: #333333;font-weight: normal;">\
                <div>\
                    <keep-alive>\
                        <component :is="deliverControl" ref="deliverControl"></component>\
                    </keep-alive>\
                    <br class="clear_both">\
                </div>\
                <div class="comment_toolbar" style="margin-top: 10px;">\
                    <span>请输入常用意见</span>\
                    <button type="button" class="btn btn_agree" @click="quickComment">同意</button>\
                    <select class="form_control" @change="selectComment($event)">\
                        <option value="">常用处理意见</option>\
                        <option :value="item.comment" v-for="item in comments">{{item.comment}}</option>\
                    </select>\
                    <label>\
                        <input type="checkbox" v-model="saveComment"> 保存为常用意见\
                    </label>\
                    <button type="button" class="btn btn_info" @click="openCommentPanel">编辑常用意见</button>\
                    <br class="clear_both">\
                </div>\
                <textarea class="form_control comment_textarea" rows="3" v-model="comment" placeholder="请在此输入意见!"></textarea>\
            </div>\
            <!--流程退回面板-->\
            <div id="processEngineReturnPanel" style="display: none; margin: 10px; color: #333333;font-weight: normal;">\
                <keep-alive>\
                    <component :is="returnExtendControl" :pass=false ref="returnExtendControl"></component>\
                </keep-alive>\
                <label style="line-height: 24px;">退回至</label>\
                <select style="width: 100%;" class="form_control" v-model="returnToRuntimeActivityId">\
                    <option :value="item.returnToRuntimeActivityId" v-for="item in currentActivity.returns">\
                        {{item.actorName == ""?"":item.actorName + "："}}{{item.activityName}}\
                    </option>\
                </select>\
                <div>\
                    <div class="comment_toolbar" style="margin-top: 10px;">\
                        <span>请输入常用意见</span>\
                        <button type="button" class="btn btn_agree" @click="quickComment(false)">不同意</button>\
                        <select class="form_control" @change="selectComment($event)">\
                            <option value="">常用处理意见</option>\
                            <option :value="item.comment" v-for="item in comments">{{item.comment}}</option>\
                        </select>\
                        <label>\
                            <input type="checkbox" v-model="saveComment"> 保存为常用意见 \
                        </label>\
                        <button type="button" class="btn btn_info" @click="openCommentPanel">编辑常用意见</button>\
                        <br class="clear_both">\
                    </div>\
                    <textarea class="form_control comment_textarea" rows="3" v-model="comment" placeholder="请在此输入意见!"></textarea>\
                </div>\
            </div>\
            <!--流程撤回面板-->\
            <div id="processEngineTakeBackPanel" style="display: none; margin: 10px; color: #333333;font-weight: normal;">\
                <label style="line-height: 24px;">撤回至</label>\
                <select class="form_control" style="width: 100%;" v-model="takeBackToRuntimeActivityId">\
                    <option :value="item.takeBackToRuntimeActivityId" v-for="item in takeBacks">\
                        {{item.activityName}}\
                    </option>\
                </select>\
                <div class="comment_toolbar" style="margin-top: 10px;">\
                    <span>请输入常用意见</span>\
                    <button type="button" class="btn btn_agree" @click="quickComment">同意</button>\
                    <select class="form_control" @change="selectComment($event)">\
                        <option value="">常用处理意见</option>\
                        <option :value="item.comment" v-for="item in comments">{{item.comment}}</option>\
                    </select>\
                    <label>\
                        <input type="checkbox" v-model="saveComment"> 保存为常用意见 \
                    </label>\
                    <button type="button" class="btn btn_info" @click="openCommentPanel">编辑常用意见</button>\
                    <br class="clear_both">\
                </div>\
                <textarea class="form_control comment_textarea" rows="3" v-model="comment" placeholder="请在此输入意见!"></textarea>\
            </div>\
            <!--常用意见管理面板-->\
            <div id="processEngineCommentPanel" style="display: none; margin: 10px; color: #333333;font-weight: normal;">\
                <table class="table_list table_striped table_hover text_center">\
                    <thead><tr>\
                        <th>常用意见</th>\
                        <th>操作</th>\
                    </tr></thead>\
                    <tbody><tr v-for="(item, index) in comments" v-if="!item.system">\
                        <td class="text-left">{{item.comment}}</td>\
                        <td>\
                            <i title="删除" class="iconfont icon-delete tooltip" type="danger" @click="deleteComment(item)"></i>\
                        </td>\
                    </tr></tbody>\
                </table>\
            </div>\
        </div>',
        props: {
            deploySid: '',                                              //部署流程标识符
            domainId: '',                                               //领域对象Id
            //saveDraft: {type: Function, default: undefined},            //暂存当前编辑页
            beforeProcess: {type: Function, default: undefined},          //打开流程操作弹窗前事件
        },
        data: function () {
            return {
                accountId: '',                                   //用户ID
                // deploySid: '',                                   //部署流程标识符
                runtimeProcessId: '',                            //运行时流程Id，流程未启动时为空
                pendingActivities: [],                           //需处理的活动，同一个处理人可能有多个需处理的活动
                currentActivity: {actions: [], returns: []},     //选择的处理活动
                currentAction: {},                               //当前处理动作
                takeBacks: [],                                   //可撤回至的活动
                returnToRuntimeActivityId: '',                   //选择的要退回至的活动
                takeBackToRuntimeActivityId: '',                 //选择的要撤回至的活动
                actionExtendControl: '',                         //处理时扩展组件标识
                returnExtendControl: '',                         //退回时扩展组件标识
                additionalControl: '',                           //附加组件标识
                deliverControl: '',                              //转交组件标识
                //处理意见
                comments: [],                                    //常用意见，包括系统和用户自定义
                comment: '',                                     //处理意见，处理、转交、退回、撤回时共用
                saveComment: false,                              //是否设为常用意见
                historiesExtend: {},                             //流程历史，带扩展信息
                //由调用页面设置的各类参数
                additionalControlParams: {},                     //附加组件参数对象
                actionSwitchParams: {},                          //处理动作开关参数对象
                deliverControlParams: undefined,                 //转交组件参数对象
            }
        },
        computed: {
            peacDescription: function () {
                return this.currentAction.description == '' ? '已选择人员' : this.currentAction.description;
            }
        },
        watch: {
            deploySid: function (newValue, oldValue) {
                this.loadProcess();
            },
            domainId: function (newValue, oldValue) {
                this.loadProcess();
            }
        },
        created: function () {
            this.getCurrentUser();
        },
        mounted: function () {
            this.loadComments();
            this.loadProcess();
        },
        methods: {
            getCurrentUser: function () {
                var that = this;
                //加载当前登陆人accountId
                $.ajax({
                    url: getContextPath() + '/auth/current-user',
                    type: "get",
                    async: false,
                    success: function (res) {
                        that.accountId = res.data.id;
                    }
                });
            },
            // 快捷意见
            quickComment: function (type) {
                if (type == false)
                    this.comment = "不同意。";
                else
                    this.comment = "同意。";
            },
            // 左侧按钮添加图标
            itemAddClass: function (item) {
                if (item.name == '审批')
                    return 'review';
                else if (item.name == '转交')
                    return 'transfer';
                else if (item.name == '会签')
                    return 'countersign';
                else
                    return 'internal_countersign'
            },
            //初始化流程组件，发起状态
            /*initProcess: function (pendingData) {
                this.deploySid = pendingData.deploySid;
                //this.runtimeProcessId = pendingData.runtimeProcessId;   //初始化时runtimeProcessId为空
                this.pendingActivities = pendingData.pendingActivities;
                this.takeBacks = pendingData.takeBacks;
                this.selectActivity();
                this.loadComments();
            },*/
            //初始化流程组件，处理状态
            /*            loadProcess: function (pendingData) {
                            this.deploySid = pendingData.deploySid;
                            this.runtimeProcessId = pendingData.runtimeProcessId;
                            this.pendingActivities = pendingData.pendingActivities;
                            this.takeBacks = pendingData.takeBacks;
                            this.selectActivity();
                            this.loadComments();
                        },*/
            loadProcess: function () {
                var that = this;
                $.ajax({
                    type: 'get',
                    async: false,
                    url: '../../v1/process-engine/process/pending-process',
                    /*  data: {
                          "domainId": that.domainId,
                          "deploySid": "wirelessCostNJ",
                          "loginUserId":that.currentLoginUser.accountId
                      },*/
                    data: {deploySid: that.deploySid, domainId: that.domainId, loginUserId: that.accountId},
                    success: function (data) {
                        var pendingData = data.data;
                        that.runtimeProcessId = pendingData.runtimeProcessId;
                        that.pendingActivities = pendingData.pendingActivities;
                        that.selectActivity();
                        that.loadComments();
                        that.takeBacks = data.data.takeBacks;
                        if (that.takeBacks.length > 0)
                            //默认选中第一个能撤回的步骤
                            that.takeBackToRuntimeActivityId = that.takeBacks[0].takeBackToRuntimeActivityId;
                    }
                });
            },
            //业务暂存
            /* pendingSaveDraft: function () {
                  this.saveDraft();
             },*/
            //设置附加组件参数
            setAdditionalControlParams: function (name, value) {
                Vue.set(this.additionalControlParams, name, value);
            },
            //设置处理动作开关参数
            setActionSwitchParams: function (name, value) {
                Vue.set(this.actionSwitchParams, name, value);
            },
            //设置转交组件参数
            setDeliverControlParams: function (value) {
                this.deliverControlParams = value;
            },
            //取当前处理活动，可用于判断当前所处流程
            getActivity: function () {
                return this.currentActivity;
            },
            //切换处理活动
            selectActivity: function (event) {
                var index = 0;  //默认选择第一个处理活动显示系统活动
                if (event != undefined) {
                    index = event.target.selectedIndex;
                    //event.target.options.selectedIndex;
                }
                if (this.pendingActivities.length > 0) {
                    this.currentActivity = this.pendingActivities[index];
                } else {
                    this.currentActivity = {actions: [], returns: []};
                }
                //切换处理活动后回调事件
                this.$emit("activity-change", this.currentActivity);
            },
            //切换处理动作
            selectAction: function (action) {
                this.currentAction = action;
                //切换处理动作时改变附加组件
                this.additionalControl = action.additionalControl;
                //当有附加组件时，且需要为附加组件设置参数，且提供了对应的参数值，为附加组件设置参数值
                if (action.additionalControl != '' && action.additionalControlParam != ''
                    && this.additionalControlParams.hasOwnProperty(action.additionalControlParam)) {
                    var that = this;
                    //切换附加组件需在nextTick中$refs才能获取组件实例
                    this.$nextTick(function () {
                        //当附加组件有setParams方法时为附加组件设置参数值
                        if (that.$refs.additionalControl.setParams) {
                            that.$refs.additionalControl.setParams(that.additionalControlParams[action.additionalControlParam]);
                        }
                    });
                }
            },
            //处理
            openActionPanel: function () {
                if (this.beforeProcess != undefined) {
                    if (!this.beforeProcess('action')) {
                        return;
                    }
                }
                //打开处理窗口时初始化选中的动作
                var that = this;
                var valid = false;
                var firstAction = undefined;
                $.each(this.currentActivity.actions,
                    function (index, item) {
                        if (!item.switchable || String(that.actionSwitchParams[item.switchParam]) == 'true') {
                            if (!firstAction) {
                                firstAction = item;
                            }
                            if (item.nextActivityId == that.currentAction.nextActivityId) {
                                valid = true;
                                return false; //break
                            }
                        }
                    });
                if (!valid)
                    this.currentAction = firstAction;
                if (this.currentAction == undefined) {
                    alert('未找到可执行的处理动作。');
                    return;
                }
                //打开处理窗口时绑定附加组件
                this.additionalControl = this.currentAction.additionalControl;
                //设置附加组件参数
                if (this.additionalControl != '' && this.currentAction.additionalControlParam != ''
                    && this.additionalControlParams.hasOwnProperty(this.currentAction.additionalControlParam)) {
                    this.$nextTick(function () {
                        if (that.$refs.additionalControl.setParams) {
                            that.$refs.additionalControl.setParams(that.additionalControlParams[that.currentAction.additionalControlParam]);
                        }
                    });
                }
                //打开处理窗口时绑定扩展组件
                this.actionExtendControl = this.currentActivity.extendControl;
                var canActive = true
                layer.open({
                    type: 1,
                    area: '750px',
                    offset: '100px',
                    title: this.currentActivity.name,
                    content: $('#processEngineActionPanel'),
                    btn: ['确定', '取消'],
                    yes: function (index, layero) {
                        if (!canActive) return
                        canActive = false
                        //验证附加组件值
                        var additionalControlValue = undefined;
                        if (that.$refs.additionalControl != undefined) {
                            if (that.$refs.additionalControl.verifyValue != undefined) {
                                if (!that.$refs.additionalControl.verifyValue()) {
                                    canActive = true
                                    return;
                                }
                            }
                            additionalControlValue = that.$refs.additionalControl.getValue();
                        }
                        //验证处理意见
                        if (that.currentAction.commentRequired) {
                            if ($.trim(that.comment) == '') {
                                canActive = true
                                alert('请输入' + that.currentAction.commentLabel + '。');
                                return;
                            }
                        }
                        //取扩展组件值
                        var extendControlValue = undefined;
                        if (that.$refs.actionExtendControl != undefined) {
                            if (that.$refs.actionExtendControl.verifyValue != undefined) {
                                if (!that.$refs.actionExtendControl.verifyValue()) {
                                    canActive = true
                                    return;
                                }
                            }
                            extendControlValue = that.$refs.actionExtendControl.getValue();
                        }
                        if (that.runtimeProcessId) {
                            //流程处理数据
                            var data = {
                                runtimeProcessId: that.runtimeProcessId,
                                currentActivityId: that.currentActivity.id,
                                nextActivityId: that.currentAction.nextActivityId,
                                additionalControlValue: JSON.stringify(additionalControlValue),
                                extendControlValue: JSON.stringify(extendControlValue),
                                comment: that.comment,
                                saveComment: that.saveComment
                            };
                            that.$emit('process-action', data);
                        } else {
                            //流程启动数据
                            var data = {
                                deploySid: that.deploySid,
                                currentActivityId: that.currentActivity.id,
                                nextActivityId: that.currentAction.nextActivityId,
                                additionalControlValue: JSON.stringify(additionalControlValue),
                                extendControlValue: JSON.stringify(extendControlValue),
                                comment: that.comment,
                                saveComment: that.saveComment
                            };
                            that.$emit('process-start', data);
                        }
                        layer.close(index);     //关闭弹窗
                        that.comment = '';      //处理后清空意见
                        canActive = true
                    }
                });
            },
            //转交
            openDeliverPanel: function () {
                if (this.beforeProcess != undefined) {
                    if (!this.beforeProcess('deliver')) {
                        return;
                    }
                }
                var that = this;
                //打开转交窗口时绑定组件
                this.deliverControl = this.currentActivity.deliverControl;
                //设置转交组件参数
                if (this.deliverControl != '' && this.deliverControlParams != undefined) {
                    this.$nextTick(function () {
                        if (that.$refs.deliverControl.setParams) {
                            that.$refs.deliverControl.setParams(that.deliverControlParams);
                        }
                    });
                }
                var canActive = true
                layer.open({
                    type: 1,
                    area: '600px',
                    title: '流程转交',
                    content: $('#processEngineDeliverPanel'),
                    btn: ['确定', '取消'],
                    yes: function (index, layero) {
                        if (!canActive) return;
                        canActive = false
                        //验证转交组件
                        if (that.$refs.deliverControl != undefined) {
                            if (that.$refs.deliverControl.verifyValue != undefined) {
                                if (!that.$refs.deliverControl.verifyValue()) {
                                    canActive = true
                                    return;
                                }

                            }
                            that.deliverControlValue = that.$refs.deliverControl.getValue();
                        }
                        //转交说明不必填
                        //if ($.trim(that.comment) == '') {
                        //    alert('请输入转交说明。');
                        //    return;
                        //}
                        //流程转交数据
                        var data = {
                            runtimeProcessId: that.runtimeProcessId,
                            runtimeActivityId: that.currentActivity.runtimeActivityId,
                            deliverActor: that.deliverControlValue,
                            comment: that.comment,
                            saveComment: that.saveComment
                        };
                        that.$emit('process-deliver', data);
                        layer.close(index);
                        that.comment = '';      //转交后清空意见
                        canActive = true
                    }
                });
            },
            //退回
            openReturnPanel: function () {
                if (this.beforeProcess != undefined) {
                    if (!this.beforeProcess('return')) {
                        return;
                    }
                }
                //打开退回窗口时初始化选中的退回选项
                var that = this;
                var valid = false;
                if (this.returnToRuntimeActivityId) {
                    $.each(this.currentActivity.returns,
                        function (index, item) {
                            if (item.returnToRuntimeActivityId == that.returnToRuntimeActivityId) {
                                valid = true;
                                return false; //break
                            }
                        });
                }
                if (!valid)
                    this.returnToRuntimeActivityId = this.currentActivity.returns[0].returnToRuntimeActivityId;
                //打开退回窗口时绑定扩展组件
                this.returnExtendControl = this.currentActivity.extendControl;
                var canActive = true
                layer.open({
                    type: 1,
                    area: '650px',
                    title: '流程退回',
                    content: $('#processEngineReturnPanel'),
                    btn: ['确定退回', '取消'],
                    yes: function (index, layero) {
                        //取扩展组件值
                        if (!canActive) return;
                        canActive = false

                        var extendControlValue = undefined;
                        if (that.$refs.returnExtendControl != undefined) {
                            if (that.$refs.returnExtendControl.verifyValue != undefined) {
                                if (!that.$refs.returnExtendControl.verifyValue()) {
                                    canActive = true
                                    return;
                                }

                            }
                            extendControlValue = that.$refs.returnExtendControl.getValue();
                        }
                        //流程退回数据
                        var data = {
                            runtimeProcessId: that.runtimeProcessId,
                            runtimeActivityId: that.currentActivity.runtimeActivityId,
                            returnToRuntimeActivityId: that.returnToRuntimeActivityId,
                            extendControlValue: JSON.stringify(extendControlValue),
                            comment: that.comment,
                            saveComment: that.saveComment
                        };
                        that.$emit('process-return', data);
                        layer.close(index);     //关闭弹窗
                        that.comment = '';      //退回后清空意见
                        canActive = true
                    }
                });
            },
            //撤回
            openTakeBackPanel: function () {
                if (this.beforeProcess != undefined) {
                    if (!this.beforeProcess('takeback')) {
                        return;
                    }
                }
                //打开撤回窗口时初始化选中的撤回选项
                var that = this;
                var valid = false;
                if (this.takeBackToRuntimeActivityId) {
                    $.each(this.takeBacks,
                        function (index, item) {
                            if (item.takeBackToRuntimeActivityId == that.takeBackToRuntimeActivityId) {
                                valid = true;
                                return false; //break
                            }
                        });
                }
                if (!valid)
                    this.takeBackToRuntimeActivityId = this.takeBacks[0].takeBackToRuntimeActivityId;
                var canActive = true
                layer.open({
                    type: 1,
                    area: '500px',
                    title: '流程撤回',
                    content: $('#processEngineTakeBackPanel'),
                    btn: ['确定撤回', '取消'],
                    yes: function (index, layero) {
                        if (!canActive) return
                        canActive = false
                        //撤回说明必填
                        if ($.trim(that.comment) == '') {
                            canActive = true
                            alert('请输入撤回说明。');
                            return;
                        }
                        //流程撤回数据
                        var data = {
                            runtimeProcessId: that.runtimeProcessId,
                            takeBackToRuntimeActivityId: that.takeBackToRuntimeActivityId,
                            comment: that.comment,
                            saveComment: that.saveComment
                        };
                        that.$emit('process-takeback', data);
                        layer.close(index);     //关闭弹窗
                        that.comment = '';      //撤回后清空意见
                        canActive = true
                    }
                });
            },
            //终止
            openStopPanel: function () {
                if (this.beforeProcess != undefined) {
                    if (!this.beforeProcess('stop')) {
                        return;
                    }
                }
                var that = this;
                var canActive = true
                layer.open({
                    type: 1,
                    area: '500px',
                    title: '流程终止',
                    content: $('#processEngineStopPanel'),
                    btn: ['确定终止', '取消'],
                    yes: function (index, layero) {
                        if (!canActive) return;
                        canActive = false
                        //终止说明必填
                        if ($.trim(that.comment) == '') {
                            canActive = true
                            alert('请输入终止说明。');
                            return;
                        }
                        //流程终止数据
                        var data = {
                            runtimeProcessId: that.runtimeProcessId,
                            runtimeActivityId: that.currentActivity.runtimeActivityId,
                            comment: that.comment,
                            saveComment: that.saveComment
                        };
                        that.$emit('process-stop', data);
                        layer.close(index);     //关闭弹窗
                        that.comment = '';      //终止后清空意见
                        canActive = true
                    }
                });
            },
            //加载常用意见
            loadComments: function () {
                var that = this;
                $.ajax({
                    type: 'GET',
                    url: processEngineServer + '/api/runtime/comments/' + that.accountId,
                    success: function (res) {
                        that.comments = res.data;
                    }
                });
            },
            //选择常用意见
            selectComment: function (event) {
                this.comment = event.target.value;
                event.target.selectedIndex = 0;
            },
            //管理常用意见
            openCommentPanel: function () {
                layer.open({
                    type: 1,
                    area: ['500px', '450px'],
                    title: '管理自定义常用意见',
                    content: $('#processEngineCommentPanel'),
                    btn: ['确定'],
                    yes: function (index, layero) {
                        layer.close(index);
                    }
                });
            },
            //删除常用意见
            deleteComment: function (item) {
                var that = this;
                if (confirm('确认删除常用意见“' + item.comment + '”吗？')) {
                    $.ajax({
                        type: 'POST',
                        url: processEngineServer + '/api/runtime/comments/remove',
                        data: {actor: that.accountId, comment: item.comment},
                        // contentType: 'application/json',
                        success: function (res) {
                        }
                    });
                    this.comments = $.grep(this.comments,
                        function (e) {
                            return e.comment != item.comment;
                        });
                }
            },
            //显示运行时流程图
            openRuntimeDiagram: function () {
                window.open('../../pages/process-engine/diagram.html?runtimeProcessId=' + this.runtimeProcessId);
            },
            //显示部署流程图
            openDeployDiagram: function () {
                window.open('../../pages/process-engine/diagram.html?deploySid=' + this.deploySid);
            },
        }
    });
});
