//流程引擎选择多人员组件，使用树组件
define(['jquery', 'vue', '../../libs/jquery.ztree/fuzzysearch.js'], function ($, Vue, fuzzySearch) {
    return Vue.component('peac-users-tree', {
        props: {},
        data: function () {
            return {
                selectedItems: [],
                treeId: 'tree' + Math.floor(100000000 + Math.random() * 900000000),     //生成随机id
                searchId: 'search' + Math.floor(100000000 + Math.random() * 900000000),  //生成随机id
                organization: ''
            }
        },
        template: '<div>\
                    <div class="peac_column peac_column_tree" style="overflow: hidden;">\
                        <div class="peac_column_title">\
                        <!--<a href="javascript:void(null);" @click="expand">展开</a>-->\
                        <!--<a href="javascript:void(null);" @click="collapse">收起</a>-->\
                        &nbsp;<input type="text" :id="searchId" class="form-control" placeholder="请输入搜索内容" />\
                        </div>\
                        <div class="peac_tree_container">\
                            <ul :id="treeId" class="ztree"></ul>\
                        </div>\
                    </div>\
                    <div class="peac_column peac_column_selected">\
                        <div class="peac_column_title">已选择人员</div>\
                        <div class="peac_selected_container">\
                            <div class="peac_selected_item" v-for="item in selectedItems">\
                                <div class="peac_selected_name">{{item.name}}</div>\
                                <div class="peac_selected_remove" @click="remove(item)">╳</div>\
                            </div>\
                        </div>\
                    </div>\
                </div>',
        created: function () {

        },
        mounted: function () {
            var that = this;
            var setting = {
                check: {
                    enable: true,
                    chkStyle: 'checkbox',
                    radioType: 'all',
                    //chkboxType: {'Y': 'ps', 'N': 'ps'}
                },
                view: {showIcon: false},
                callback: {
                    onClick: function (event, treeId, treeNode) {
                        var zTree = $.fn.zTree.getZTreeObj(treeId);
                        if (treeNode.isParent) {
                            if (treeNode.open) {
                                zTree.expandNode(treeNode, false);
                            } else {
                                zTree.expandNode(treeNode, true);
                            }
                        } else {
                            zTree.checkNode(treeNode, !treeNode.checked, true, true);
                        }
                    },
                    onCheck: function zTreeOnCheck(event, treeId, treeNode) {
                        //console.log(treeNode);
                        //console.log(treeId + ', ' + treeNode.tId + ', ' + treeNode.id + ', ' + treeNode.name + ',' + treeNode.checked);
                        var treeObj = $.fn.zTree.getZTreeObj(treeId);
                        var nodes = treeObj.getCheckedNodes(true);
                        console.log(nodes);
                        that.selectedItems = $.map(nodes, function (node, index) {
                            if (!node.isParent) {
                                var name = node.name;
                                if (node.oldname)
                                    name = node.oldname;
                                return {id: node.id, name: name};
                            }
                        });
                    }
                }
            };
            //获取当前用户
            $.ajax({
                type: 'GET',
                url: '/auth/current-actor',
                success: function (data) {
                    that.actor = data.data.id + '::' + data.data.displayName;
                    that.organization = data.data.organizationId;
                    $.ajax({
                        dataType: 'JSON',
                        type: 'GET',
                        url: '/api/user/pe/ztree-checkbox',
                        data: {organization: that.organization},
                        success: function (data) {
                            var zNodes = data.data;
                            var zTreeObj = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                            fuzzySearch.fuzzySearch(that.treeId, '#' + that.searchId, true, true);
                        }
                    });
                }
            });
        },
        watch: {},
        computed: {},
        methods: {
            remove: function (item) {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                var nodes = treeObj.getCheckedNodes(true);
                $.each(nodes, function (index, node) {
                    if (node.id == item.id)
                        treeObj.checkNode(node, false, true, true); //取消树节点选中
                });
                this.selectedItems = $.grep(this.selectedItems, function (selectedItem, index) {
                    return selectedItem.id != item.id;
                });
            },
            expand: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.expandAll(true);
            },
            collapse: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.expandAll(false);
            },
            search: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.fuzzySearch(false);
            },
            verifyValue: function () {
                if (this.selectedItems.length == 0) {
                    // alert('请选择处理人。');
                    layer.confirm('请选择处理人。',
                        {title:'提示',btn: ['确定'],closeBtn: 0 },
                        function(index){
                            layer.close(index);
                        });
                    return false;
                }
                return true;
            },
            getValue: function () {
                var items = $.map(this.selectedItems, function (item, index) {
                    return item.id + '::' + item.name;
                });
                return items;
            }
        }
    });
});
