//流程引擎附加组件，直接输入处理人标识
define(['jquery', 'vue'], function ($, Vue) {
    return Vue.component('peac-test', {
        props: {},
        data: function () {
            return {
                actor: ''       //处理人标识
            }
        },
        template: '<div class="nowrap">\
                        <i class="tooltip_icon" title="流程引擎测试附加组件，默认加载当前用户的id，手工输入处理人标识方便测试，生产环境请配置正确的控件">输入处理人</i>\
                        <input type="text" class="form_control" v-model="actor">\
                    </div>',
        created: function () {
            //获取当前用户
            var that = this;
            $.ajax({
                type: 'GET',
                url: '/auth/current-actor',
                success: function (data) {
                    that.actor = data.data.id + '::' + data.data.displayName;
                }
            });
        },
        mounted: function () {
        },
        watch: {},
        computed: {},
        methods: {
            verifyValue: function () {
                if(this.actor == undefined || this.actor == '') {
                    // alert('请填写处理人标识。');
                    layer.confirm('请填写处理人标识。',
                        {title:'提示',btn: ['确定'],closeBtn: 0 },
                        function(index){
                            layer.close(index);
                        });
                    return false;
                }
                return true;
            },
            getValue: function () {
                return this.actor;
            }
        }
    });
});
