package com.infoepoch.pms.dispatchassistant.domain.system.uploadFile;

import com.infoepoch.pms.dispatchassistant.common.component.AbstractCriteria;

import java.util.Date;

/**
* 上传文件记录表查询条件类
*/
public class UploadFileCriteria extends AbstractCriteria {


    //region 文件名称模糊查询
    public boolean byFileNameContain() {
        return this.andMap.containsKey("FileNameContain");
    }

    private String fileNameContain;

    public String getFileNameContain() {
        if (byFileNameContain())
            return fileNameContain;
        return null;
    }

    public void setFileNameContain(String value) {
        this.fileNameContain = value;
        this.andMap.put("FileNameContain", value);
    }
    //endregion

    //region 后缀
    public boolean byExtension() {
        return this.andMap.containsKey("Extension");
    }

    private String extension;

    public String getExtension() {
        if (byExtension())
            return extension;
        return null;
    }

    public void setExtension(String value) {
        this.extension = value;
        this.andMap.put("Extension", value);
    }
    //endregion

    //region 后缀模糊查询
    public boolean byExtensionContain() {
        return this.andMap.containsKey("ExtensionContain");
    }

    private String extensionContain;

    public String getExtensionContain() {
        if (byExtensionContain())
            return extensionContain;
        return null;
    }

    public void setExtensionContain(String value) {
        this.extensionContain = value;
        this.andMap.put("ExtensionContain", value);
    }
    //endregion

    //region 文件类型
    public boolean byContentType() {
        return this.andMap.containsKey("ContentType");
    }

    private String contentType;

    public String getContentType() {
        if (byContentType())
            return contentType;
        return null;
    }

    public void setContentType(String value) {
        this.contentType = value;
        this.andMap.put("ContentType", value);
    }
    //endregion

    //region 上传时间
    public boolean byUploadTime() {
        return this.andMap.containsKey("UploadTime");
    }

    private Date uploadTime;

    public Date getUploadTime() {
        if (byUploadTime())
            return uploadTime;
        return null;
    }

    public void setUploadTime(Date value) {
        this.uploadTime = value;
        this.andMap.put("UploadTime", value);
    }
    //endregion

    //region 是否有尺寸，只有图片文件可以计算尺寸
    public boolean byHasDimension() {
        return this.andMap.containsKey("HasDimension");
    }

    private Boolean hasDimension;

    public Boolean getHasDimension() {
        if (byHasDimension())
            return hasDimension;
        return null;
    }

    public void setHasDimension(Boolean value) {
        this.hasDimension = value;
        this.andMap.put("HasDimension", value);
    }
    //endregion

    //region 文件上传者ID
    public boolean byUploadUserId() {
        return this.andMap.containsKey("UploadUserId");
    }

    private String uploadUserId;

    public String getUploadUserId() {
        if (byUploadUserId())
            return uploadUserId;
        return null;
    }

    public void setUploadUserId(String value) {
        this.uploadUserId = value;
        this.andMap.put("UploadUserId", value);
    }
    //endregion

    //region 文件上传者姓名模糊查询
    public boolean byUploadUserNameContain() {
        return this.andMap.containsKey("UploadUserNameContain");
    }

    private String uploadUserNameContain;

    public String getUploadUserNameContain() {
        if (byUploadUserNameContain())
            return uploadUserNameContain;
        return null;
    }

    public void setUploadUserNameContain(String value) {
        this.uploadUserNameContain = value;
        this.andMap.put("UploadUserNameContain", value);
    }
    //endregion

    //region 关联领域ID
    public boolean byDomainId() {
        return this.andMap.containsKey("DomainId");
    }

    private String domainId;

    public String getDomainId() {
        if (byDomainId())
            return domainId;
        return null;
    }

    public void setDomainId(String value) {
        this.domainId = value;
        this.andMap.put("DomainId", value);
    }
    //endregion

    //region 关联单据类型
    public boolean byDomainType() {
        return this.andMap.containsKey("DomainType");
    }

    private String domainType;

    public String getDomainType() {
        if (byDomainType())
            return domainType;
        return null;
    }

    public void setDomainType(String value) {
        this.domainType = value;
        this.andMap.put("DomainType", value);
    }
    //endregion

}