package com.infoepoch.pms.dispatchassistant.domain.system.moaLog;

import java.util.List;

/**
* MOA日志记录表仓储接口
*/
public interface IMoaLogRepository {
    /**
     * 新增
     * @param: [entity]
     */
    boolean insert(MoaLog entity);

    /**
     * 更新
     * @param: [entity]
     */
    boolean update(MoaLog entity);

    /**
     * 批量新增
     * @param: [entitys]
     */
    int[] batchInsert(List<MoaLog> entitys);

    /**
     * 批量更新
     * @param: [entitys]
     */
    int[] batchUpdate(List<MoaLog> entitys);

    /**
     * 删除
     * @param: [id]
     */
    boolean delete(String id);

    // region select

    /**
     * 根据Id查询
     * @param: [id]
     */
    MoaLog selectById(String id);

    /**
     * 根据查询条件查询单个对象
     * @param: [criteria]
     */
    MoaLog selectOneByCriteria(MoaLogCriteria criteria);

    /**
     * 根据查询条件查询对象集合
     * @param: [criteria]
     */
    List<MoaLog> selectByCriteria(MoaLogCriteria criteria);

    /**
     * 根据查询条件分页查询对象结合
     * @param: [criteria, pageIndex, pageSize]
     */
    List<MoaLog> selectCriteriaByPage(MoaLogCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询对象总记录数
     * @param: [criteria]
     */
    int selectCountByCriteria(MoaLogCriteria criteria);

    // endregion
}
