package com.infoepoch.pms.dispatchassistant.domain.system.dict;


import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;

import java.util.Date;

/**
 * 系统字典类型
 */
public class SystemDictType {

    /**
     * 新增
     *
     * @param userName
     */
    public void create(String userName) {
        this.id = SnowFlake.instant().nextId().toString();
        this.status = 0;
        this.createBy = userName;
        this.createTime = new Date();
    }

    /**
     * 修改
     *
     * @param name
     * @param dictType
     * @param userName
     */
    public void modify(String name, String dictType, String userName) {
        this.name = name;
        this.dictType = dictType;
        this.updateBy = userName;
        this.updateTime = new Date();
    }

    public SystemDictType() {
    }

    /**
     * 仓储还原
     */
    public SystemDictType(String id, String name, String dictType, Integer status, String createBy, Date createTime, String updateBy,
                          Date updateTime, String remark) {
        this.id = id;
        this.name = name;
        this.dictType = dictType;
        this.status = status;
        this.createBy = createBy;
        this.createTime = createTime;
        this.updateBy = updateBy;
        this.updateTime = updateTime;
        this.remark = remark;
    }

    private String id;
    // 字典名称
    private String name;
    // 字典类型
    private String dictType;
    // 状态
    private Integer status;
    // 创建人
    private String createBy;
    // 创建时间
    private Date createTime;
    // 更新人
    private String updateBy;
    // 更新时间
    private Date updateTime;
    // 备注
    private String remark;

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDictType() {
        return dictType;
    }

    public Integer getStatus() {
        return status;
    }

    public String getCreateBy() {
        return createBy;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public String getRemark() {
        return remark;
    }
}
