package com.infoepoch.pms.dispatchassistant.controller.system;

import com.infoepoch.pms.dispatchassistant.common.component.Result;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.KeyValueStore;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.KeyValueStoreCriteria;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.KeyValueStoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/template-file")
public class TemplateFileController {

    @Autowired
    private KeyValueStoreService keyValueStoreService;

    /**
     * 键值对列表
     *
     * @param criteria
     * @return
     */
    @PostMapping("/list")
    public Result pageList(@RequestBody KeyValueStoreCriteria criteria) {
        return Result.successData(keyValueStoreService.pageList(criteria));
    }

    /**
     * 新增键值对
     *
     * @param keyValueStore
     * @return
     */
    @PostMapping("/save-file-template")
    public Result add(@RequestBody KeyValueStore keyValueStore) {
        keyValueStore.fileIdListToValue();
        keyValueStoreService.addKeyValue(keyValueStore);
        return Result.success();
    }

    /**
     * 修改值
     *
     * @param keyValueStore
     * @return
     */
    @PostMapping("/modify-file-template")
    public Result modify(@RequestBody KeyValueStore keyValueStore) {
        keyValueStore.fileIdListToValue();
        keyValueStoreService.modifyKeyValue(keyValueStore);
        return Result.success();
    }

}
