package com.infoepoch.pms.dispatchassistant.controller.langchain;


import com.infoepoch.pms.dispatchassistant.common.component.Result;
import com.infoepoch.pms.dispatchassistant.common.exception.NotLoginException;
import com.infoepoch.pms.dispatchassistant.controller.basic.Auth;
import com.infoepoch.pms.dispatchassistant.domain.basic.user.User;
import com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation.Conversation;
import com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation.ConversationCriteria;
import com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation.ConversationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/conversation")
public class ConversationController {

    @Autowired
    private Auth auth;
    @Autowired
    private ConversationService conversationService;

    /**
     * 分页列表
     *
     * @param criteria
     * @return
     */
    @PostMapping("/list")
    public Result pageList(@RequestBody ConversationCriteria criteria) {
        return Result.successData(conversationService.pageList(criteria));
    }

    /**
     * 我的会话列表
     *
     * @param criteria
     * @return
     * @throws NotLoginException
     */
    @PostMapping("/my-list")
    public Result myList(@RequestBody ConversationCriteria criteria) throws NotLoginException {
        User user = auth.getUserReq();
        criteria.setUserId(user.getId());
        return Result.successData(conversationService.pageList(criteria));
    }

    /**
     * 新增会话
     * @param conversation
     * @return
     */
    @PostMapping("/add-conversation")
    public Result addConversation(@RequestBody Conversation conversation) throws NotLoginException {
        User user = auth.getUserReq();
        conversationService.save(conversation, user);
        return Result.successData(conversation);
    }


}
