package com.infoepoch.pms.dispatchassistant.common.utils;

import org.springframework.jdbc.support.rowset.SqlRowSet;

import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

/**
 * 数据库工具类
 */
public class DatabaseUtils {

    public static String getBigField(ResultSet rs, String columnName) {
        try {
            String text = ClobToString(rs.getObject(columnName));
            if (StringUtils.isBlank(text))
                return "";
            return text;
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * 取Oracle nclob字段
     */
    public static String getBigField(SqlRowSet sqlRowSet, String columnName) {
        try {
            String text = ClobToString(sqlRowSet.getObject(columnName));
            if (StringUtils.isBlank(text))
                return "";
            return text;
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * 将字Clob转成String类型
     */
    private static String ClobToString(Object obj) {
        try {
            SerialClob sc = (SerialClob) obj;
            String reString = "";
            // 得到流
            Reader is = sc.getCharacterStream();
            BufferedReader br = new BufferedReader(is);
            String s = br.readLine();
            StringBuffer sb = new StringBuffer();
            while (s != null) {
                // 执行循环将字符串全部取出付值给StringBuffer由StringBuffer转成STRING
                sb.append(s);
                s = br.readLine();
            }
            reString = sb.toString();
            return reString;
        } catch (SerialException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 取Mysql TIMESTAMP字段，有异常抛出
     */
    public static Date getTimestampReq(SqlRowSet sqlRowSet, String columnName) throws SQLException {
        Object obj = sqlRowSet.getObject(columnName);
        if (!(obj instanceof Timestamp))
            throw new SQLException("无法解析TIMESTAMP字段：" + columnName);
        Timestamp ts = (Timestamp) obj;
        Date date = ts;
        return date;
    }

    /**
     * 取Mysql TIMESTAMP字段，有异常返回null
     */
    public static Date getTimestamp(SqlRowSet sqlRowSet, String columnName) {
        Object obj = sqlRowSet.getObject(columnName);
        if (!(obj instanceof Timestamp))
            return null;
        Timestamp ts = (Timestamp) obj;
        try {
            return new Date(ts.getTime());
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * java.util.Date转为java.sql.Date
     */
    public static java.sql.Date toSqlDate(Date date) {
        if (date == null)
            return null;
        return new java.sql.Date(date.getTime());
    }

    /**
     * Mysql.sql.TIMESTAMP转为java.sql.Timestamp
     */
    public static Timestamp toSqlTimestamp(Object obj) {
        if (!(obj instanceof Timestamp))
            return null;
        try {
            return (Timestamp) obj;
        } catch (Exception e) {
            throw new RuntimeException("转换java.sql.Timestamp时发生异常。");
        }
    }

    /**
     * java.util时间类型转换为java.sql.Timestamp
     */
    public static <T extends Date> Timestamp toSqlTimestamp(T date) {
        if (null == date) {
            return null;
        }
        return new Timestamp(date.getTime());
    }
}
