/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.Datum;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class INTERVALDS
extends Datum {
    private static int MAXLEADPREC = 9;
    private static int MAXHOUR = 23;
    private static int MAXMINUTE = 59;
    private static int MAXSECOND = 59;
    private static final int INTERVALDS_BYTE_NUM = 14;
    private static int INTERVALDSMAXLENGTH = 11;
    private static int INTERVALDSOFFSET = 60;
    private static int INTERVALDAYOFFSET = Integer.MIN_VALUE;

    public INTERVALDS() {
        super(INTERVALDS.toBytes("0 0:0:0.0"));
    }

    public INTERVALDS(byte[] bytes) {
        super(bytes);
    }

    public INTERVALDS(String stringVal) {
        super(INTERVALDS.toBytes(stringVal));
    }

    public static byte[] toBytes(String var) {
        if (var == null) {
            return null;
        }
        byte[] intervaldsBytes = new byte[14];
        String trimStr = var.trim();
        char ch = var.charAt(0);
        int is_negative = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int fractional_second = 0;
        int pos = 0;
        if (ch != '-' && ch != '+') {
            pos = 0;
        } else {
            pos = 1;
            if (ch == '-') {
                is_negative = 1;
            }
        }
        String subStr = trimStr.substring(pos);
        int index = subStr.indexOf(32);
        String dayStr = subStr.substring(0, index);
        if (dayStr.length() > MAXLEADPREC) {
            throw new NumberFormatException("invalid daylen " + dayStr);
        }
        day = Integer.valueOf(dayStr);
        StringTokenizer tokenizer = new StringTokenizer(subStr = subStr.substring(index + 1), ":.");
        if (tokenizer.hasMoreTokens()) {
            String fracSecondStr;
            String secondStr;
            String minuteStr;
            String hourStr;
            try {
                hourStr = tokenizer.nextToken();
                minuteStr = tokenizer.nextToken();
                secondStr = tokenizer.nextToken();
                try {
                    fracSecondStr = tokenizer.nextToken();
                }
                catch (Exception ex) {
                    fracSecondStr = null;
                }
            }
            catch (Exception ex) {
                throw new NumberFormatException("invalid format " + var);
            }
            hour = Integer.valueOf(hourStr);
            minute = Integer.valueOf(minuteStr);
            second = Integer.valueOf(secondStr);
            if (hour > MAXHOUR) {
                throw new NumberFormatException("invalid hour " + hour + " in " + var);
            }
            if (minute > MAXMINUTE) {
                throw new NumberFormatException("invalid minute  " + minute + " in " + var);
            }
            if (second > MAXSECOND) {
                throw new NumberFormatException("invalid second  " + second + " in " + var);
            }
            if (fracSecondStr != null) {
                if (fracSecondStr.length() > MAXLEADPREC) {
                    throw new NumberFormatException("invalid fracsecond length " + fracSecondStr + " in " + var);
                }
                fractional_second = Integer.valueOf(fracSecondStr);
                int lenDiff = MAXLEADPREC - fracSecondStr.length();
                for (int i = 0; i < lenDiff; ++i) {
                    fractional_second *= 10;
                }
            }
        } else {
            throw new NumberFormatException("invalid format " + var);
        }
        intervaldsBytes[0] = (byte)(is_negative & 0xFF);
        byte[] tmpBytes = INTERVALDS.intToBytes(day);
        System.arraycopy(tmpBytes, 0, intervaldsBytes, 1, 4);
        intervaldsBytes[5] = (byte)(hour & 0xFF);
        intervaldsBytes[6] = (byte)(minute & 0xFF);
        intervaldsBytes[7] = (byte)(second & 0xFF);
        tmpBytes = INTERVALDS.intToBytes(fractional_second);
        System.arraycopy(tmpBytes, 0, intervaldsBytes, 8, 4);
        intervaldsBytes[12] = (byte)(dayStr.length() & 0xFF);
        intervaldsBytes[13] = (byte)MAXLEADPREC;
        return intervaldsBytes;
    }

    public static String toString(byte[] data) {
        if (data != null && data.length != 0) {
            if (data.length != 14) {
                throw new InvalidParameterException("invalid len:" + data.length);
            }
            int is_negative = data[0] & 0xFF;
            int day = INTERVALDS.getInt(data, 1);
            int hour = data[5] & 0xFF;
            int minute = data[6] & 0xFF;
            int second = data[7] & 0xFF;
            int fractional_second = INTERVALDS.getInt(data, 8);
            int day_scale = data[12] & 0xFF;
            int fractional_second_scale = data[13] & 0xFF;
            if (day < 0 || (double)day > Math.pow(10.0, MAXLEADPREC)) {
                throw new NumberFormatException("day should not exceed " + Math.pow(10.0, MAXLEADPREC) + ", now is " + day);
            }
            if (hour < 0 || hour > MAXHOUR) {
                throw new NumberFormatException("hour should not exceed " + MAXHOUR + ", now is " + hour);
            }
            if (minute < 0 || minute > MAXMINUTE) {
                throw new NumberFormatException("minute should not exceed " + MAXMINUTE + ", now is " + minute);
            }
            if (second < 0 || second > MAXSECOND) {
                throw new NumberFormatException("second should not exceed " + MAXSECOND + ", now is " + second);
            }
            if (fractional_second < 0 || (double)fractional_second > Math.pow(10.0, MAXLEADPREC)) {
                throw new NumberFormatException("fractional_second should not exceed " + Math.pow(10.0, MAXLEADPREC) + ", now is " + fractional_second);
            }
            if (fractional_second_scale < 0 || fractional_second_scale > MAXLEADPREC) {
                throw new NumberFormatException("fractional_second_scale should not exceed " + MAXLEADPREC + ", now is " + fractional_second_scale);
            }
            if (fractional_second_scale < MAXLEADPREC) {
                fractional_second /= (int)Math.pow(10.0, MAXLEADPREC - fractional_second_scale);
            }
            String format = String.format("%%d %%d:%%d:%%d.%%0%dd", fractional_second_scale);
            String result = String.format(format, day, hour, minute, second, fractional_second);
            int endIndex = result.length() - 1;
            int i = result.length() - 1;
            while (result.charAt(i) != '.') {
                if (result.charAt(i) != '0') {
                    endIndex = i;
                    break;
                }
                --i;
            }
            result = result.substring(0, endIndex + 1);
            if (is_negative == 0) {
                return result;
            }
            return "-" + result;
        }
        return new String();
    }

    @Override
    public String stringValue() {
        return INTERVALDS.toString(this.getBytes());
    }

    @Override
    public boolean isConvertibleTo(Class targetClass) {
        return targetClass.getName().compareTo("java.lang.String") == 0;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public Object makeJdbcArray(int intVal) {
        INTERVALDS[] object = new INTERVALDS[intVal];
        return object;
    }

    public String toString() {
        return INTERVALDS.toString(this.getBytes());
    }
}

